// login.js
const DEV_MODE = false;
const API_BASE_URL = DEV_MODE ? 'http://hirefast.local/api/' : 'https://hirefast.me/api/';

const emailInput    = document.getElementById('emailInput');
const sendCodeBtn   = document.getElementById('sendCodeBtn');
const codeSection   = document.getElementById('codeSection');
const codeInput     = document.getElementById('codeInput');
const verifyCodeBtn = document.getElementById('verifyCodeBtn');
const loginMessage  = document.getElementById('loginMessage');
const backBtn       = document.getElementById('backBtn');

function showMsg(msg) {
    loginMessage.textContent = msg || '';
    loginMessage.classList.toggle('hidden', !msg);
}

sendCodeBtn?.addEventListener('click', async () => {
    const email = (emailInput.value || '').trim();
    if (!email) { showMsg('Please enter your email address.'); return; }
    showMsg('Sending code...');
    try {
        const resp = await fetch(`${API_BASE_URL}request-code.php`, {
            method: 'POST',
            headers: {'Content-Type':'application/json'},
            body: JSON.stringify({ email })
        });
        const data = await resp.json();
        if (data?.success) {
            showMsg('Code sent. Check your email, then enter it below.');
            codeSection.classList.remove('hidden');
        } else {
            showMsg(data?.error || 'Failed to send login code.');
        }
    } catch (e) {
        showMsg(e?.message || 'Failed to send login code.');
    }
});

verifyCodeBtn?.addEventListener('click', async () => {
    const email = (emailInput.value || '').trim();
    const code  = (codeInput.value || '').trim();
    if (!code || code.length !== 4) { showMsg('Please enter the 4-digit code.'); return; }
    showMsg('Verifying...');
    try {
        const resp = await fetch(`${API_BASE_URL}verify-code.php`, {
            method: 'POST',
            headers: {'Content-Type':'application/json'},
            body: JSON.stringify({ email, code })
        });
        const data = await resp.json();
        if (data?.token) {
            chrome.storage.local.set({ authToken: data.token, userEmail: email }, () => {
                showMsg('Login successful. You can close this tab.');
            });
        } else {
            showMsg(data?.error || 'Invalid code.');
        }
    } catch (e) {
        showMsg(e?.message || 'Failed to verify code.');
    }
});

backBtn?.addEventListener('click', () => {
    // Opens the popup (user needs to click the action again after this)
    chrome.runtime.openOptionsPage(); // just re-open options if they want
    window.close();
});
